import gym
import sys
import numpy as np
#sys.path.insert(0,"C:\\Users\\harim\\OneDrive\\Bureaublad\\capstone_project\\highway_env_master")
#sys.path.insert(0,"C:\\Users\\harim\\OneDrive\\Bureaublad\\capstone_project\\highway_env_master")
#sys.path.insert(0,"C:\\Users\\Leuke Mens\\Documents\\GitHub\\drlcarsim\\learntodrive")
import highway_env
from highway_env.road.lane import StraightLane
from highway_env.vehicle.kinematics import Vehicle

env = gym.make("complex_city-v0")#roundabout-v0
env.configure({
    'manual_control': False
    # "action": {
    #      "type": "ContinuousAction"
    }
)
env.reset()
term = False

destination = env.road.network.get_random_destination()
print(env.observation_space, env.action_space)
print('destination:', destination)
ego_car = env.controlled_vehicles[0]

print('speed', ego_car.speed, ego_car.position)
print('lane (index)', ego_car.lane, ego_car.lane_index)

ego_car.plan_route_to(destination)
i = 0

while not term and i < 27:
    road_network = env.road.network
    action = 0
    obs_space, reward, term, trunc, info = env.step(action)
    #print(env.get_available_actions())
    # print(reward)
    # print(info)

    if len(ego_car.route) < 2:
        new_destination = env.road.network.get_random_destination()
        ego_car.plan_route_to(new_destination)
        print("new route")
        i += 1

    ego_car.lane = road_network.get_closest_lane_index(ego_car.position)
    print(ego_car.route)
    env.render()
